 ;  LD - Lisp loader
 ;  Copyright 1991, 2010 by Rocket Software Ltd.
 ;  Saves time wasted on repeated typing errors.
 ;  Shares ff default with XX.lsp and Find.lsp for easy editing & reloading.
 (DEFUN C:LD (/ fn tt len locnam loca)
  (if (= (type ff) 'str)
      (setq tt (strcat "File to load <" ff ">: "))
      (setq tt "File to load: "))
  (setq fn (getstring T tt))
  (if (/= fn "") (setq ff fn))
  (setq len (strlen ff))
  (if (or (<= len 4) (/= (substr (strcase ff t) (- len 3)) ".lsp"))
      (setq locnam (strcat ff ".lsp"))
      (setq locnam ff))
  (cond ((setq loca (findfile (strcat (getvar "dwgprefix") locnam)))
         (write-line loca)
         (setq fn (load loca ()))
         (if fn
            (print fn)
            (write=line "\nLoad Failed.")))
        ((setq loca (findfile locnam))
         (write-line loca)
         (setq fn (load loca ()))
         (if fn
            (print fn)
            (write=line "\nLoad Failed.")))
        ((setq loca (load ff ())) ; if no extension on ff load tries .fas, .vlx
         (write-line loca))
        (t
         (write-line (strcat "\nCan't load " locnam))))
 (princ))